-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local I18nDictionary = class(function(self)
	self._keysToValues = {}
end)

function I18nDictionary:setValues(keysToValues)
	if type(keysToValues) ~= 'table' then
		error('Invalid i18n dictionary supplied')
	end

	self._keysToValues = keysToValues
end

function I18nDictionary:getValue(key)
	return self._keysToValues[key]
end

return I18nDictionary