-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local IElement = plugins.views:lazyRequire("core.types.IElement")

--[[
-- Object used by the XML->Lua generator to group together all view and fragment
-- definitions which result from the same XML file.
--]]
local DefinitionScope = class(function(self, xmlFilePath)
	-- Path to the XML file that was parsed.
	self._xmlFilePath = xmlFilePath

	-- Reference to the main View definition found in the XML file (there must
	-- be exactly one View definition per XML file).
	self._viewDefinition = nil

	-- Map of any fragments found in the XML file, mapped against their class name.
	self._fragmentDefinitions = {}
end)

function DefinitionScope:getXmlFilePath()
	return self._xmlFilePath
end

function DefinitionScope:getViewDefinition()
	return self._viewDefinition
end

function DefinitionScope:setViewDefinition(viewDefinition)
	self._viewDefinition = viewDefinition
end

function DefinitionScope:getFragmentDefinitions()
	return self._fragmentDefinitions
end

function DefinitionScope:getFragmentDefinition(className)
	return self._fragmentDefinitions[className]
end

function DefinitionScope:setFragmentDefinition(className, fragmentDefinition)
	self._fragmentDefinitions[className] = fragmentDefinition
end

function DefinitionScope:finalize()
	self._viewDefinition:setDefinitionScope(self)
	self._viewDefinition:setType(IElement.TYPE_VIEW)

	for fragmentName, fragmentDefinition in pairs(self._fragmentDefinitions) do
		fragmentDefinition:setDefinitionScope(self)
		fragmentDefinition:setType(IElement.TYPE_VIEW_FRAGMENT)
	end
end

return DefinitionScope