-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local ViewRegistry = class(function(self)
	self._viewInstances = {}
	self._count = 0
end)

--[[
-- Adds the supplied view to the viewInstances map, which will hold onto it
-- until it is destroyed.
--
--]]
function ViewRegistry:registerViewInstance(view)
	local uuid = view:getUuid()

	if self._viewInstances[uuid] == nil then
		self._viewInstances[uuid] = view
		self._count = self._count + 1
	end
end

--[[
-- Removes the view associated with the supplied viewUuid from the map.
--
--]]
function ViewRegistry:unregisterViewInstance(view)
	local uuid = view:getUuid()

	if self._viewInstances[uuid] ~= nil then
		self._viewInstances[uuid] = nil
		self._count = self._count - 1
	end
end

--[[
-- Returns a view instance for the supplied viewUuid, if one exists.
--
--]]
function ViewRegistry:getViewInstanceByUuid(viewUuid)
	return self._viewInstances[viewUuid]
end

--[[
-- The a map of all views by their UUID.
--
--]]
function ViewRegistry:getViewInstances()
	return self._viewInstances
end

function ViewRegistry:getCount()
	return self._count
end

return ViewRegistry