-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local utils = lazyRequire('pl.utils')

local SceneNodeOpsQueue = class(function(self)
	self._sceneNodeOps = {}
end)

function SceneNodeOpsQueue:queueOp(parentNode, operation, ...)
	if parentNode == nil then
		error("SceneNodeOpsQueue:queueOp parentNode must not be nil")
	end

	if not utils.is_callable(parentNode[operation]) then
		error("SceneNodeOpsQueue:queueOp invalid scene node operation")
	end

	table.insert(self._sceneNodeOps,
	{
		parent = parentNode,
		operation = operation,
		arg = {...}
	})
end

function SceneNodeOpsQueue:queueCallback(callback, ...)
	if not utils.is_callable(callback) then
		error("SceneNodeOpsQueue:queueOp invalid callback")
	end

	table.insert(self._sceneNodeOps,
	{
		callback = callback,
		arg = {...}
	})
end

function SceneNodeOpsQueue:flushOps()
	while #self._sceneNodeOps > 0 do
		local op = table.remove(self._sceneNodeOps, 1)

		if op.callback ~= nil then
			self:_flushCallback(op)
		elseif op.parent ~= nil then
			self:_flushOp(op)
		end
	end
end

function SceneNodeOpsQueue:_flushOp(operation)
	operation.parent[operation.operation](
		operation.parent,
		unpack(operation.arg))
end

function SceneNodeOpsQueue:_flushCallback(operation)
	operation.callback(unpack(operation.arg))
end

return SceneNodeOpsQueue