-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local ViewFactory = plugins.views:lazyRequire('core.context.ViewFactory')
local ViewRegistry = plugins.views:lazyRequire('core.context.ViewRegistry')
local NodesRegistry = plugins.views:lazyRequire('core.context.NodesRegistry')
local SceneNodeOpsQueue = plugins.views:lazyRequire('core.context.SceneNodeOpsQueue')
local TickableRegistry = plugins.views:lazyRequire('core.context.TickableRegistry')
local LookupPrefix = plugins.views:lazyRequire('core.LookupPrefix')
local Validators = plugins.views:lazyRequire('core.validation.Validators')
local DefinitionTable = plugins.views:lazyRequire('core.definitions.DefinitionTable')
local I18nDictionary = plugins.views:lazyRequire('core.i18n.I18nDictionary')

--[[
-- State-global tables for storing view and directive definitions
--
--]]

local Context = class(function(self)
	self._viewFactory = ViewFactory.new()
	self._viewRegistry = ViewRegistry.new()
	self._nodesRegistry = NodesRegistry.new()
	self._tickableRegistry = TickableRegistry.new()
	self._sceneNodeOpsQueue = SceneNodeOpsQueue.new()

	self._viewDefinitionTable =
			DefinitionTable.new(Validators.view, LookupPrefix.VIEWS)

	self._directiveDefinitionTable =
			DefinitionTable.new(Validators.directive, LookupPrefix.DIRECTIVES)

	self._i18nDictionary = I18nDictionary.new()
end)

function Context:getViewFactory()
	return self._viewFactory
end

function Context:getViewRegistry()
	return self._viewRegistry
end

function Context:getNodesRegistry()
	return self._nodesRegistry
end

function Context:getViewDefinitionTable()
	return self._viewDefinitionTable
end

function Context:getDirectiveDefinitionTable()
	return self._directiveDefinitionTable
end

function Context:getI18nDictionary()
	return self._i18nDictionary
end

function Context:getSceneNodeOpsQueue()
	return self._sceneNodeOpsQueue
end

function Context:getTickableRegistry()
	return self._tickableRegistry
end

return Context