-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractDataBufferPositioner = plugins.views:lazyRequire('views.infiniteList.data.positioning.AbstractDataBufferPositioner')
local Viewport = plugins.views:lazyRequire('views.infiniteList.view.Viewport')

local LookaheadDataBufferPositioner = class(AbstractDataBufferPositioner,
	function(self, lookahead)
		if type(lookahead) ~= 'number' then
			error('The lookahead argument is required, and must be a number')
		end

		self._lookahead = lookahead
	end)

function LookaheadDataBufferPositioner:_getStartAndEndIndices(viewport)
	if viewport:getDirectionOfTravel() == Viewport.DIRECTION_FORWARDS then
		return viewport:getStartIndex(), viewport:getEndIndex()+self._lookahead
	elseif viewport:getDirectionOfTravel() == Viewport.DIRECTION_BACKWARDS then
		return viewport:getStartIndex()-self._lookahead, viewport:getEndIndex()
	end
end

return LookaheadDataBufferPositioner