-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local IBehaviour = plugins.views:lazyRequire('views.behaviours.IBehaviour')

local WrappingBehaviour = class(IBehaviour, function(self)
end)

function WrappingBehaviour:complementIteratorOptions(iteratorOptions)
	iteratorOptions:addOption("wrappingEnabled", true)
end

function WrappingBehaviour:adjustElementsPosition(iterationViews, oldActiveIndex, newActiveIndex)
	local middleIndex = math.ceil(#iterationViews/2)

	-- If empty set, return zero for the index
	if middleIndex == 0 then
		return iterationViews, 0, 0
	end

	local delta = oldActiveIndex - newActiveIndex

	-- Adjusting delta to account for wrapping
	if delta <= -middleIndex then
		delta = #iterationViews + delta
	elseif delta >= middleIndex then
		delta = delta - #iterationViews
	end

	-- Rotating views in order to have current selected element in the middle
	local offset = newActiveIndex - middleIndex
	local adjustedViews = {}
	for i = 1, #iterationViews do
		table.insert(adjustedViews, iterationViews[
				self:_computeIndex(offset, #iterationViews)])
		offset = offset + 1
	end

	return adjustedViews, middleIndex, delta
end

function WrappingBehaviour:_computeIndex(offset, iterationViewsCount)
	return math.fmod(offset + iterationViewsCount, iterationViewsCount) + 1
end

return WrappingBehaviour
