-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local BehaviourFactory = class(function(self)
end)

BehaviourFactory._behaviourCache = {}

function BehaviourFactory.createBehaviour(behaviourName)
	local behaviour = BehaviourFactory._behaviourCache[behaviourName]

	if not behaviour then
		behaviour = plugins.views:lazyRequire('views.behaviours.' .. behaviourName)
		if behaviour == nil then
			error("cannot create unknown behavior: " .. behaviourName)
		end
	end

	BehaviourFactory._behaviourCache[behaviourName] = behaviour
	return behaviour
end

return BehaviourFactory
