-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local IndexTranslator = class(function(self)
end)

function IndexTranslator.getRelativeIndexWithinDataSet(index, dataSetSize)
	if dataSetSize == nil then
		return index
	end
	assert(
		dataSetSize > 0,
		"dataSetSize has to be positive integer"
	)

	local wrapIndex = math.fmod(index - 1, dataSetSize) -- mod operations are 0 based.

	if wrapIndex < 0 then
		wrapIndex = wrapIndex + dataSetSize
	end

	return wrapIndex + 1
end

return IndexTranslator
