-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local TypeChecker = class(function(self)
end)

function TypeChecker.isRGB(tableValue)
	if type(tableValue) ~= "table" then return false end

	local isRGB = TypeChecker._isNumber(tableValue.r) and
			TypeChecker._isNumber(tableValue.g) and
			TypeChecker._isNumber(tableValue.b)
	return isRGB
end

function TypeChecker.isXYZ(tableValue)
	if type(tableValue) ~= "table" then return false end

	local isXYZ = TypeChecker._isNumber(tableValue.x) and
			TypeChecker._isNumber(tableValue.y) and
			TypeChecker._isNumber(tableValue.z)
	return isXYZ
end

function TypeChecker.isRGBA(tableValue)
	if type(tableValue) ~= "table" then return false end

	local isRGBA = TypeChecker.isRGB(tableValue) and
			TypeChecker._isNumber(tableValue.a)
	return isRGBA
end

function TypeChecker.isXYZW(tableValue)
	if type(tableValue) ~= "table" then return false end

	local isXYZW = TypeChecker.isXYZ(tableValue) and
			TypeChecker._isNumber(tableValue.w)
	return isXYZW
end

function TypeChecker._isNumber(value)
	return type(value) == "number"
end

return TypeChecker
