-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local ScrollingTimer = class(function(self, intervalDuration)
	self._intervalDuration = intervalDuration
	self._isRunning = false
	self._lastTickTimestamp = nil
end)

function ScrollingTimer:start()
	self:_checkForValidInterval()
	self._isRunning = true
end

function ScrollingTimer:_checkForValidInterval()
	assert(type(self._intervalDuration) == "number", 
			"scrolling timer interval should be a number")
end

function ScrollingTimer:stop()
	self._isRunning = false
	self._lastTickTimestamp = nil
end

function ScrollingTimer:isRunning()
	return self._isRunning
end

function ScrollingTimer:onInterval(callback, context)
	self._onInterval = callback
	self._onIntervalContext = context	
end

function ScrollingTimer:getInterval()
	return self._intervalDuration
end

function ScrollingTimer:setInterval(newValue)
	self._intervalDuration = newValue
	self:_checkForValidInterval()
end

function ScrollingTimer:tick()
	if self._isRunning then
		self:_tick()
	elseif self._lastTickTimestamp ~= nil then
		self:stop()
	end
end

function ScrollingTimer:_tick()
	local time = timer.getTimeInMilliseconds()
	local diffTime = time - (self._lastTickTimestamp or 0)

	if diffTime > self._intervalDuration then
		self._onInterval(self._onIntervalContext, diffTime)
		self._lastTickTimestamp = time
	end
end

return ScrollingTimer
