-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local OpsContainer = plugins.views:lazyRequire('utils.OpsContainer')

local OpsBuilder = class(function(self, rootModel)
	self._rootOpsContainer = OpsContainer.create(rootModel)
	self._currentOpsContainer = self._rootOpsContainer
	self._containerStack = { self._rootOpsContainer }
end)

function OpsBuilder:getRootOpsContainer()
	return self._rootOpsContainer
end

function OpsBuilder:getCurrentOpsContainer()
	return self._currentOpsContainer
end

function OpsBuilder:enterChild(name, model)
	local childOpsContainer = self._currentOpsContainer:addChild(name, model)
	table.insert(self._containerStack, childOpsContainer)
	self._currentOpsContainer = childOpsContainer
end

function OpsBuilder:exitChild()
	table.remove(self._containerStack)
	self._currentOpsContainer = self._containerStack[#self._containerStack]
end

function OpsBuilder:setLocal(name, type, value)
	self._currentOpsContainer:setLocal(name, value, type)
end

-- This method was created so that we can add other attributes that may be
-- needed by the Ops. For example, when we apply an OPERATION_UPDATE to
-- a node's tag, we have first to remove the previous tags and only then create
-- the new ones, so the 'oldValue' attribute is required.
function OpsBuilder:extendLocal(name, propertyName, value)
	self._currentOpsContainer:extendLocal(name, propertyName, value)
end

function OpsBuilder:setType(type)
	self._currentOpsContainer:setType(type)
end

return OpsBuilder