-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local SignalInterceptor = plugins.lua:lazyRequire("signals.SignalInterceptor")

local function noOp()
	return false
end

local KeyRepeatInterceptor = class(function(self, priority)
	self._longKeyPressInterceptor = SignalInterceptor.new(
			input.longKeyPressSignal, priority, self._interceptLongKeyPress, self)

	self._keyPressInterceptor = SignalInterceptor.new(
			input.keyPressSignal, priority, noOp, self)

	self._keyUpInterceptor = SignalInterceptor.new(
			input.keyUpSignal, priority, self._interceptKeyUp, self)
end)

function KeyRepeatInterceptor:activate()
	self._longKeyPressInterceptor:activate()
	self._keyUpInterceptor:activate()
end

function KeyRepeatInterceptor:deactivate()
	self._longKeyPressInterceptor:deactivate()
	self._keyPressInterceptor:deactivate()
	self._keyUpInterceptor:deactivate()
end

function KeyRepeatInterceptor:onKeyRepeat(onKeyRepeatCallback, context)
	self._onKeyRepeat = onKeyRepeatCallback
	self._onKeyRepeatContext = context
end

function KeyRepeatInterceptor:onKeyUp(onKeyUpCallback, context)
	self._onKeyUp = onKeyUpCallback
	self._onKeyUpContext = context
end

function KeyRepeatInterceptor:_interceptLongKeyPress(keyCode, keyModifier)
	self._keyUpInterceptor:activate()

	local callOtherInterceptors = self:_callCallback(
			self._onKeyRepeat, self._onKeyRepeatContext, keyCode, keyModifier)

	-- Explicit comparing with 'false', as other
	-- 'false-like' values should not trigger this
	if callOtherInterceptors == false then
		self._keyPressInterceptor:activate()
	end

	return callOtherInterceptors
end

function KeyRepeatInterceptor:_interceptKeyUp(keyCode, keyModifier)
	return self:_callCallback(
			self._onKeyUp, self._onKeyUpContext, keyCode, keyModifier)
end

function KeyRepeatInterceptor:_callCallback(callback, context, keyCode, keyModifier)
	if callback then
		if context ~= nil then
			return callback(context, keyCode, keyModifier)
		else
			return callback(keyCode, keyModifier)
		end
	end
end

function KeyRepeatInterceptor:dispose()
	self._longKeyPressInterceptor:dispose()
	self._keyPressInterceptor:dispose()
	self._keyUpInterceptor:dispose()
end

return KeyRepeatInterceptor