-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractPropertyManager = plugins.views:lazyRequire('properties.iterator.propertyManagers.AbstractPropertyManager')

local YPropertyManager = class(AbstractPropertyManager, function(self)
end)

function YPropertyManager:getIteratingDirections()
	return {["up"] = true, ["down"] = true}
end

function YPropertyManager:getPropertiesAffectingNodeSize()
	return { height = true }
end

function YPropertyManager:getNodeSize(node)
	return node:getHeight()
end

function YPropertyManager:getValue(node)
	return node:getY()
end

function YPropertyManager:getMinBound(node)
	return node:getBottom()
end

function YPropertyManager:getMaxBound(node)
	return node:getTop()
end

function YPropertyManager:setValue(node, value)
	node:setY(value)
end

function YPropertyManager:setMinBound(node, value)
	node:setY(value + node:getPivotPosition().y + node:getHeight() / 2)
end

function YPropertyManager:setMaxBound(node, value)
	node:setY(value + node:getPivotPosition().y - node:getHeight() / 2)
end

function YPropertyManager:getPropertyName()
	return "y"
end

return YPropertyManager
