-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractPropertyManager = class(function(self)
end)

function AbstractPropertyManager:getIteratingDirections()
	error("AbstractPropertyManager:getIteratingDirections() is not implemented!")
end

function AbstractPropertyManager:getPropertiesAffectingNodeSize()
	error("AbstractPropertyManager:getPropertiesAffectingNodeSize() is not implemented!")
end

function AbstractPropertyManager:getNodeSize(node)
	error("AbstractPropertyManager:getNodeSize() is not implemented!")
end

function AbstractPropertyManager:getValue(node)
	error("AbstractPropertyManager:getValue() is not implemented!")
end

function AbstractPropertyManager:getMinBound(node)
	error("AbstractPropertyManager:getMinBound() is not implemented!")
end

function AbstractPropertyManager:getMaxBound(node)
	error("AbstractPropertyManager:getMaxBound() is not implemented!")
end

function AbstractPropertyManager:setValue(node, value)
	error("AbstractPropertyManager:setValue() is not implemented!")
end

function AbstractPropertyManager:setMinBound(node, value)
	error("AbstractPropertyManager:setMinBound() is not implemented!")
end

function AbstractPropertyManager:setMaxBound(node, value)
	error("AbstractPropertyManager:setMaxBound() is not implemented!")
end

function AbstractPropertyManager:getPropertyName()
	error("AbstractPropertyManager:getPropertyName() is not implemented!")
end

function AbstractPropertyManager:move(node, displacement)
	self:setValue(node, self:getValue(node) + displacement)
end

function AbstractPropertyManager:__eq(other)
	return self.getPropertyName() == other.getPropertyName()
end

return AbstractPropertyManager
