-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractSpacingIterator = plugins.views:lazyRequire("properties.iterator.internal.AbstractSpacingIterator")

local FixedSpacingIterator = class(AbstractSpacingIterator,
	function(self, propertyManager, spacing)
		self:_checkParameter(
				spacing,
				"spacing",
				"number",
				"FixedSpacingIterator")

		AbstractSpacingIterator._ctor(self, propertyManager,
				self:_getMultiplierForSpacing(spacing))

		self._spacing = spacing
	end)

function FixedSpacingIterator:_getMultiplierForSpacing(spacing)
	if spacing < 0 then
		return -1
	else
		return 1
	end
end

function FixedSpacingIterator:_iterationStep(index, node)
	return self._spacing * (index-1)
end

function FixedSpacingIterator:_computeDelta(elements, options)
	local delta = options.startingPositionShift - options.itemInFirstPosition
	return delta * self._spacing
end

function FixedSpacingIterator:__eq(other)
	return AbstractSpacingIterator.__eq(self, other) and
			self._spacing == other._spacing
end

return FixedSpacingIterator
