-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractSpacingIterator = plugins.views:lazyRequire("properties.iterator.internal.AbstractSpacingIterator")
local SpacingCalculator = plugins.views:lazyRequire("properties.iterator.spacing.SpacingCalculator")
local DeltaCalculator = plugins.views:lazyRequire("properties.iterator.spacing.DeltaCalculator")

local DynamicSpacingIterator = class(AbstractSpacingIterator,
	function(self, propertyManager, margin, alignment)
		self:_checkParameter(
				margin,
				"margin",
				"number",
				"DynamicSpacingIterator")

		AbstractSpacingIterator._ctor(
			self, propertyManager, self:_getMultiplierForMargin(margin))

		self._margin = math.abs(margin)
		self._alignment = alignment or "min"
	end)

function DynamicSpacingIterator:_getMultiplierForMargin(margin)
	if margin < 0 then
		return -1
	else
		return 1
	end
end

function DynamicSpacingIterator:_preprocess(elements, options)
	AbstractSpacingIterator._preprocess(self, elements, options)

	self._spacingCalculator = SpacingCalculator.new(elements,
			self._multiplier, self._propertyManager, self._margin)
end

function DynamicSpacingIterator:_postprocess()
	self._spacingCalculator = nil
end

function DynamicSpacingIterator:_iterationStep(index, node)
	return self._spacingCalculator:getSpacingBetweenElements(1, index)
end

function DynamicSpacingIterator:_computeDelta(elements, options)
	local deltaCalculator = DeltaCalculator(
			self._spacingCalculator, self._alignment, options)

	return deltaCalculator:getDelta()
end

function DynamicSpacingIterator:__eq(other)
	return AbstractSpacingIterator.__eq(self, other) and
			self._margin == other._margin
end

return DynamicSpacingIterator
