-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local CentralDynamicSpacingIterator = plugins.views:lazyRequire("properties.iterator.internal.CentralDynamicSpacingIterator")
local YPropertyManager = plugins.views:lazyRequire("properties.iterator.propertyManagers.YPropertyManager")

local CentralDynamicSpacingVertical = class(CentralDynamicSpacingIterator, function(self, settings)
	CentralDynamicSpacingIterator._ctor(self, YPropertyManager.new(), -settings.spacing)
end)

-- This is a special case, since the elements should be iterated "down"
-- when the margin is 0, but Y grows to the top of the screen.
function CentralDynamicSpacingVertical:_getMultiplierForMargin(margin)
	if margin <= 0 then
		return -1
	else
		return 1
	end
end

return CentralDynamicSpacingVertical
