-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local DefaultPropertyFactory = class()

DefaultPropertyFactory._propertyCache = {}

function DefaultPropertyFactory:create(propertyName, propertyDescription)
	if self:_isClassInstanceDescription(propertyDescription) then
		return self:_createClassInstanceFromDescription(propertyName, propertyDescription)
	else
		-- simply return the property description itself if it does not correspond
		-- to a typed object
		return propertyDescription
	end
end

function DefaultPropertyFactory:_isClassInstanceDescription(propertyDescription)
	return type(propertyDescription) == "table" and
			type(propertyDescription.className) == "string"
end

function DefaultPropertyFactory:_createClassInstanceFromDescription(
		propertyName, propertyDescription)
	local propertyClassName = propertyDescription.className
	propertyDescription.className = nil
	local specificPropertyClassPath = "properties." .. propertyName .. "." .. propertyClassName
	local propertyClassPath = "properties." .. propertyClassName

	local PropertyClass = DefaultPropertyFactory._propertyCache[
			specificPropertyClassPath]

	if not PropertyClass then
		local function _require(fullyQualifiedClassName)
			PropertyClass = plugins.views:lazyRequire(fullyQualifiedClassName)
		end

		local success, err = pcall(_require, specificPropertyClassPath)
		if not success then
			success = pcall(_require, propertyClassPath)
		end

		if not success then
			PropertyClass = nil
		end

		DefaultPropertyFactory._propertyCache[
				specificPropertyClassPath] = PropertyClass
	end

	if PropertyClass then
		return PropertyClass.new(propertyDescription)
	else
		log.error("Failed to find a class definition for view property with " ..
				"className '" .. propertyClassName .. "'")
		return propertyDescription
	end
end

return DefaultPropertyFactory
