-- Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local ParentDirective = DirectiveClass('SceneNodeDirective')
local Directive = class(ParentDirective)

--[[
-- @inheritdoc
--
--]]
Directive.typeName = 'VideoNodeDirective'

function Directive:_createNode()
	return SceneNodeFactory.createVideoNode()
end

Directive.setterTable = ParentDirective:mergeSetters(
{
	source = function (node, value) node:open(tostring(value)) end
})

return Directive