-- Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local ParentDirective = DirectiveClass('SceneNodeDirective')
local Directive = class(ParentDirective)
local ColorToVec = lazyRequire("directives.utils.ColorToVec")

--[[
-- @inheritdoc
--
--]]
Directive.typeName = 'ContainerNodeDirective'

function Directive:_createNode()
	return SceneNodeFactory.createContainerNode()
end

Directive.setterTable = ParentDirective:mergeSetters(
{
	backgroundColor = function (node, value)
		value = ColorToVec(value) or value
		node:setBackgroundColor(value)
	end
})

return Directive
