-- Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local TableValidtor = {}

--[[
-- Checks to see if a given subject definition is a table or not
--
--]]
local function isTable (def, defName, defType)
	if (type(def) ~= "table") then
		log.error("Definition for", defType, "named", defName, "was not a table.")
		return false
	else
		return true
	end
end

--[[
-- Checks to see if a given subject definition has a named function
--
--]]
local function hasFunction (subject, fnName, defType, defName)
	if (type(subject) ~= "table") or (type(subject[fnName]) ~= "function") then
		log.error("Definition for", defType, "named", defName, "is missing it ", fnName, " function")
		return false
	else
		return true
	end
end

--[[
-- Creates a validator function
--
--]]
function TableValidtor.createValidator(defType, fnNames)
	return function (def, defName)
		local isValid = true

		defType = defType or "(un-named type)"
		defName = defName or "(un-named value)"
		fnNames = fnNames or {}

		if isTable(def, defName, defType) then
			for key, fnName in pairs(fnNames) do
				isValid = (isValid == true) and hasFunction(def, fnName, defType, defName)
			end
		else
			isValid = false
		end

		return isValid
	end
end

return TableValidtor