-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

-- [[
-- Toggles a property by creating it if value == true, and it's NOT marked as
-- deleted; else delete it.
--
-- ]]
local deleteIfFalse = function(prop, value)
    if (prop.type ~= OpsContainer.OPERATION_DELETE) and
            (prop.value == true) then
        prop.type = OpsContainer.OPERATION_CREATE
    else
        prop.type = OpsContainer.OPERATION_DELETE
    end
    prop.value = value
end

return deleteIfFalse
