-- Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local TableHelpers = {}

--[[
-- Take the array values in source and set them as keys in dest
--]]
function TableHelpers.mergeValues(source, dest)
	for key, value in pairs(source) do
		dest[value] = true
	end
end

--[[ Take each key in the source and do a 'mergeValues' on each value
--
--]]
function TableHelpers.mergeSubKeys(source, dest)
	for key, value in pairs(dest) do
		if type(source[key]) == 'table' then
			TableHelpers.mergeValues(source[key], value)
		end
	end
end

--[[ Convert the map keys to an array
--
--]]
function TableHelpers.getKeys(source)
	local arr = {}
	for key, v in pairs(source) do
		table.insert(arr, key)
	end
	return arr
end

return TableHelpers