-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local utils = lazyRequire('pl.utils')

local TickableRegistry = class(function(self)
	self._tickables = {}
end)

function TickableRegistry:addTickable(tickable)
	if tickable == nil then
		error("TickableRegistry:addTickable tickable must not be nil")
	end

	if not utils.is_callable(tickable.tick) then
		error("TickableRegistry:addTickable object must have tick method")
	end

	table.insert(self._tickables, tickable)
end

function TickableRegistry:removeTickable(tickable)
	for index, t in ipairs(self._tickables) do
		if t == tickable then
			table.remove(self._tickables, index)
			break
		end
	end

end

function TickableRegistry:tick()
	for _, tickable in ipairs(self._tickables) do
		tickable:tick()
	end
end


return TickableRegistry