-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local NodesRegistry = class(function(self)
	self._sceneNodeIdToViewElement = {}
end)

function NodesRegistry:add(nodeId, viewElement)
	if (viewElement) then
		self._sceneNodeIdToViewElement[nodeId] = viewElement
	end
end

function NodesRegistry:remove(nodeId)
	self._sceneNodeIdToViewElement[nodeId] = nil
end

function NodesRegistry:getViewElement(nodeId)
	return self._sceneNodeIdToViewElement[nodeId]
end

return NodesRegistry