/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_TTY_EXTERNAL_TTY_EVENTS_TTY_EVENT_H_
#define PLUGIN_TTY_EXTERNAL_TTY_EVENTS_TTY_EVENT_H_

#include <utils/UUID.h>
#include <event/EventService.h>
#include <event/EventHandler.h>
#include <event/events/Event.h>

#include "TtyConfig.h"
#include "TtyKeyboardConstants.h"

namespace ignition
{
namespace tty
{

class PLUGINTTY_API TtyEvent : public core::event::Event
{
	REGISTER_EVENT(TtyEvent);

public:
	static const core::event::EventName KEY_UP;
	static const core::event::EventName KEY_DOWN;
	static const core::event::EventName KEY_PRESS;

	static TtyEvent* create(
			const core::event::EventName name,
			const core::UUID& sender,
			const KeyCode keyCode,
			const KeyModifier keyModifier);

	static TtyEvent* clone(const TtyEvent& rhs);
	static TtyEvent& cast(core::event::Event& event);

	virtual ~TtyEvent();
	TtyEvent(const TtyEvent& other);
	TtyEvent& operator=(const TtyEvent& rhs);

	KeyCode getKeyCode() const;
	KeyModifier getKeyModifier() const;

	virtual void accept(
			core::event::EventHandler* const handler,
			core::event::Context& ctx);

	virtual std::string toString();

private:
	TtyEvent(
			const core::event::EventName,
			const core::UUID&,
			const KeyCode,
			const KeyModifier);

	KeyCode _keyCode;
	KeyModifier _keyModifier;
};

} /* namespace tty */
} /* namespace ignition */

#endif /* PLUGIN_TTY_EXTERNAL_TTY_EVENTS_TTY_EVENT_H_ */
