/* Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#include "ignition/texttospeech/PluginTextToSpeech.h"
#include "ignition/texttospeech/bindings/sm/TextToSpeechExtension.h"
#include "ignition/texttospeech/bindings/sm/generated/PluginTextToSpeechBinder.h"
#include "ignition/texttospeech/engine/TextToSpeechEngine.h"
#include "ILua.h"
#include "IJavaScript.h"

namespace ignition
{
namespace texttospeech
{

REGISTER_PLUGIN(texttospeech, PluginTextToSpeech);

PluginTextToSpeech::PluginTextToSpeech()
{
}

PluginTextToSpeech::~PluginTextToSpeech()
{
}

void PluginTextToSpeech::satisfyDependencies(core::plugin::IPlugin::DependencyMap dependencies)
{
	_javaScript = core::plugin::GetPlugin<javascript::IJavaScript>(dependencies);
	_lua = core::plugin::GetPlugin<lua::ILua>(dependencies);
}

void PluginTextToSpeech::start()
{
	Log::get().enableLogChannel(ITextToSpeech::ID(), "TextToSpeech");
	Log::get().info(ITextToSpeech::ID(), "PluginTextToSpeech::start()");
	_ttsEngine.reset(new engine::TextToSpeechEngine());
	_addSpiderMonkeyBindings();
}

void PluginTextToSpeech::stop()
{
	Log::get().info(ITextToSpeech::ID(), "PluginTextToSpeech::stop()");
	Log::get().disableLogChannel(ITextToSpeech::ID());
	_ttsBinder.reset();
}

void PluginTextToSpeech::tick()
{

}

engine::TextToSpeechEngine* PluginTextToSpeech::getTextToSpeechEngine()
{
	return _ttsEngine.get();
}

void PluginTextToSpeech::_addSpiderMonkeyBindings()
{
	javascript::sm::SpiderMonkeyEnvironment* env =
			_javaScript->getSpiderMonkeyEnv();
	_ttsExtension = new bindings::sm::TextToSpeechExtension(env, _ttsEngine.get());

	_ttsBinder = core::memory::UniquePtr<sm::PluginTextToSpeechBinder>(
			new sm::PluginTextToSpeechBinder(env, nullptr));
	_ttsBinder->setDestructorUnbindAction(
			javascript::sm::Binder::DestructorUnbindAction::UNBIND_ON_DESTRUCT);
	_ttsBinder->setTextToSpeechExtension(_ttsExtension);
	_ttsBinder->bind();
}

} // namespace texttospeech
} // namespace ignition
