/* Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_TEXTTOSPEECH_PLUGIN_TEXT_TO_SPEECH_H_ 
#define IGNITION_TEXTTOSPEECH_PLUGIN_TEXT_TO_SPEECH_H_ 

#include "ignition/texttospeech/ITextToSpeech.h"
#include "SmartPointers.h"

namespace ignition
{

namespace javascript
{
class IJavaScript;
} // namespace javascript

namespace lua
{
class ILua;
} // namespace lua

namespace texttospeech
{
namespace bindings
{
namespace sm
{
class TextToSpeechExtension;
} // namespace sm
} // namspace bindings

namespace sm
{
class PluginTextToSpeechBinder;
} // namespace sm

namespace engine
{
class TextToSpeechEngine;
} // namespace engine

class PluginTextToSpeech : public ITextToSpeech
{
public:
	PluginTextToSpeech();
	virtual ~PluginTextToSpeech();

	void satisfyDependencies(core::plugin::IPlugin::DependencyMap dependencies);
	void start();
	void tick();
	void stop();

	engine::TextToSpeechEngine* getTextToSpeechEngine();

private:
	void _addSpiderMonkeyBindings();

	core::memory::UniquePtr<engine::TextToSpeechEngine> _ttsEngine;
	lua::ILua* _lua;
	javascript::IJavaScript* _javaScript;
	bindings::sm::TextToSpeechExtension* _ttsExtension;
	core::memory::UniquePtr<sm::PluginTextToSpeechBinder> _ttsBinder;
	
};

} // namespace texttospeech
} // namespace ignition

#endif // IGNITION_TEXTTOSPEECH_PLUGIN_TEXT_TO_SPEECH_H_ 
