/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_STYLE_BINDINGS_LUA_BRIDGE_MANAGER_LUA_BINDING_H_
#define PLUGIN_STYLE_BINDINGS_LUA_BRIDGE_MANAGER_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <bindings/types/LuaReflectableValueBinding.h>

#include "rules/BridgeManager.h"
#include "StyleConfig.h"

namespace ignition
{

CREATE_FFI_USER_DATA(BridgeManager, style);

namespace style
{
extern "C"
{

using namespace core;

/* @begin_ffi_externs */

typedef struct BridgeManagerUserData BridgeManagerUserData;

PLUGINSTYLE_API bool style_BridgeManager_setVariable(
		BridgeManagerUserData* self,
		const char* variableName,
		ReflectableValueUserData* reflectableValue);

PLUGINSTYLE_API ReflectableValueUserData* style_BridgeManager_getVariable(
		BridgeManagerUserData* self,
		const char* variableName);

/* @end_ffi_externs */

} // extern "C"
} // namespace core
} // namespace ignition

#endif // PLUGIN_STYLE_BINDINGS_LUA_BRIDGE_MANAGER_LUA_BINDING_H_
