/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_STYLE_BINDINGS_LUA_ASSET_PRELOADER_LUA_BINDING_H_
#define PLUGIN_STYLE_BINDINGS_LUA_ASSET_PRELOADER_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <bindings/types/LuaReflectableValueBinding.h>

#include "rules/AssetPreloader.h"
#include "StyleConfig.h"

namespace ignition
{

CREATE_FFI_USER_DATA(AssetPreloader, style);

namespace style
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct AssetPreloaderUserData AssetPreloaderUserData;

PLUGINSTYLE_API void style_AssetPreloader_preload(
		AssetPreloaderUserData* self,
		const char* source);

PLUGINSTYLE_API unsigned int style_AssetPreloader_getConcurrentPreloadLimit(
		AssetPreloaderUserData* self);

PLUGINSTYLE_API void style_AssetPreloader_setConcurrentPreloadLimit(
		AssetPreloaderUserData* self,
		unsigned int limit);

PLUGINSTYLE_API void style_AssetPreloader_clear(
		AssetPreloaderUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace core
} // namespace ignition

#endif // PLUGIN_STYLE_BINDINGS_LUA_ASSET_PRELOADER_LUA_BINDING_H_
