/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_STYLE_BINDINGS_LUA_RULE_DEFINITION_MANAGER_LUA_BINDING_H_
#define PLUGIN_STYLE_BINDINGS_LUA_RULE_DEFINITION_MANAGER_LUA_BINDING_H_

#include "rules/RuleDefinitionManager.h"
#include "ffi/LuaFFIUserData.h"
#include "StyleConfig.h"

namespace ignition
{

CREATE_FFI_USER_DATA(RuleDefinitionManager, style);

namespace style
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct RuleDefinitionManagerUserData RuleDefinitionManagerUserData;

PLUGINSTYLE_API bool style_RuleDefinitionManager_loadRulesFromFile(
		RuleDefinitionManagerUserData* self,
		const char* path,
		const char* partition);

PLUGINSTYLE_API void style_RuleDefinitionManager_queueLoadRulesFromFile(
		RuleDefinitionManagerUserData* self,
		const char* path,
		const char* partition);

PLUGINSTYLE_API bool style_RuleDefinitionManager_flushFileQueue(
		RuleDefinitionManagerUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace core
} // namespace ignition

#endif // PLUGIN_STYLE_BINDINGS_LUA_RULE_DEFINITION_MANAGER_LUA_BINDING_H_
