-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local PrintableBindingUpdateInfo = class(function(
		self, 
		sourceNode, 
		sourceProperty, 
		targetNode, 
		targetProperty,
		value)
		
	self._sourceNode = sourceNode
	self._sourceNodeId = sourceNode:getId()
	self._sourceProperty = sourceProperty
	self._targetNode = targetNode
	self._targetNodeId = targetNode:getId()
	self._targetProperty = targetProperty
	self._value = value
	
end)

function PrintableBindingUpdateInfo:getSourceNode()
	return self._sourceNode
end

function PrintableBindingUpdateInfo:getSourceProperty()
	return self._sourceProperty
end

function PrintableBindingUpdateInfo:getTargetNode()
	return self._targetNode
end

function PrintableBindingUpdateInfo:getTargetProperty()
	return self._targetProperty
end

function PrintableBindingUpdateInfo:getValue()
	return self._value
end

function PrintableBindingUpdateInfo:getEdgeString()
	return string.format('%u -> %u [ label="%s, %s, %.1f" ];', 
			self._sourceNodeId, 
			self._targetNodeId, 
			self._sourceProperty,
			self._targetProperty,
			self._value)
end

return PrintableBindingUpdateInfo