
-- Returns true if the supplied ordinal-indexed table contains the supplied value
local function arrayContainsValue(theTable, theValue)
	for i = 1, #theTable do
		if theTable[i] == theValue then
			return true
		end
	end

	return false
end

-- Removes all instances of the supplied value from the supplied ordinal-indexed
-- table if present.
local function removeValueFromArray(theTable, theValue)
	for i = 1, #theTable do
		if theTable[i] == theValue then
			table.remove(theTable, i)
		end
	end
end

-- Removes a single occurrence of the supplied value from the supplied ordinally
-- indexed table if present.
local function removeSingleValueFromArray(theTable, theValue)
	for i = 1, #theTable do
		if theTable[i] == theValue then
			table.remove(theTable, i)
			break
		end
	end
end

-- Returns a new array containing all items from arrayA not in arrayB.
local function itemsFromArrayANotInArrayB(arrayA, arrayB)
	local difference = {}

	for i = 1, #arrayA do
		local item = arrayA[i]

		if not arrayContainsValue(arrayB, item) then
			table.insert(difference, item)
		end
	end

	return difference
end

-- Inserts all items from arrayB into arrayA
local function joinArrays(arrayA, arrayB)
	for i = 1, #arrayB do
		table.insert(arrayA, arrayB[i])
	end
end

-- Returns true if all values in the supplied table are of the same type.
local function allOfType(theTable, theType)
	for key, value in pairs(theTable) do
		if type(value) ~= theType then
			return false
		end
	end

	return true
end

-- Performs a non-recursive copy of the supplied table, returning the copy.
local function shallowCopy(theTable)
	local copy = {}

	for key, value in pairs(theTable) do
		copy[key] = value
	end

	return copy
end

-- Public exports.
return
{
	arrayContainsValue = arrayContainsValue,
	removeValueFromArray = removeValueFromArray,
	removeSingleValueFromArray = removeSingleValueFromArray,
	itemsFromArrayANotInArrayB = itemsFromArrayANotInArrayB,
	joinArrays = joinArrays,
	allOfType = allOfType,
	shallowCopy = shallowCopy
}