
local ffi = lazyRequire('ffi')

local NUMBER_TYPE = 'number'

-- Converts the supplied value to a suitable LuaReflectableType.
local function convertToReflectable(value)

	local reflectableValue = ReflectableValueUserData.new()

	-- TODO (pcowburn) Currently this will convert all numbers to floats, which
	-- will make it impossible to animate ints, doubles etc. Needs fixing, although
	-- how the fix looks will depend on the new ReflectableValue (i.e. the replacement
	-- for ReflectableTypes_t).
	if (type(value) == NUMBER_TYPE) then
		reflectableValue:setFloat(value)

	elseif ffi.istype(LuaVec2, value) then
		reflectableValue:setVec2(value)

	elseif ffi.istype(LuaVec3, value) then
		reflectableValue:setVec3(value)

	elseif ffi.istype(LuaVec4, value) then
		reflectableValue:setVec4(value)

	end

	return reflectableValue

end

-- Public exports.
return
{
	convertToReflectable = convertToReflectable
}



