
--[[

	Symbol used for selecting nodes by one or more tags, e.g. ".foo.bar"

  ]]--

local VALID_START_CHARACTERS  = '%.'
local VALID_MIDDLE_CHARACTERS = '[%a%d%-_]'

return
{
	-- Friendly name for this symbol type
	name = 'tag',

	-- Character to be used to begin this symbol in a selector. The pattern
	-- below matches just a '.'
	prefix = VALID_START_CHARACTERS,

	-- Function to be used to read this symbol from the raw selector string.
	-- This function will be called at the start of the symbol, and is expected
	-- to read until the end of the symbol, modifying the context as necessary.
	--
	-- Here we just keep reading until the end of the tag, and then add the
	-- tag to the current segment. The pattern matches any alphanumeric character,
	-- and also allows hyphens and underscores.
	reader = function(segment, parseContext)

		-- Skip past the '.' character, as we don't want it in the tag name
		parseContext:seek()

		-- Read the rest of the tag
		local tag  = parseContext:readUntilMatchFails(VALID_MIDDLE_CHARACTERS)

		-- Add the tag to the segment
		segment:addTag(tag)

	end,

	-- Function called when the number of occurrences of this symbol type in a
	-- given expression is being calculated. Supplied with a segment, the job
	-- of this function is just to return the number of symbols in the segment.
	counter = function(segment)

		-- Just return the number of tags that were found in the segment.
		return #segment.tags

	end
}

