-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

--
-- Maintains a cache of matchability keys (see MatchabilityKeyCalculator.cpp in
-- PluginScene) to the last set of matches that was generated for a node with 
-- that key. Used for sharing matches across different nodes that share the same
-- matchability characteristics.
--
local MatchabilityCache = class(function(self)

	self:clearAll()

end)

function MatchabilityCache:clearAll()
	self._cachesByPartition = {}
end

function MatchabilityCache:clearPartition(partition)
	self._cachesByPartition[partition] = nil
end

function MatchabilityCache:getMatchesForMatchabilityKey(partition, key)
	return self:_getOrCreateCacheBucket(partition)[key]
end

function MatchabilityCache:setMatchesForMatchabilityKey(partition, key, matches)
	self:_getOrCreateCacheBucket(partition)[key] = matches
end

function MatchabilityCache:_getOrCreateCacheBucket(partition)
	local cacheBucket = self._cachesByPartition[partition]
	
	if not cacheBucket then
		cacheBucket = {}
		self._cachesByPartition[partition] = cacheBucket
	end
	
	return cacheBucket
end

return MatchabilityCache