
local config = plugins.style:lazyRequire('selectors.config')

local _loadSymbols
local _printSymbolError
local _symbolDefinitions
local _symbolsByType

local SymbolLoader =
{
	getSymbolsAsList = function()
		return _symbolDefinitions
	end,

	getSymbolsByType = function()
		return _symbolsByType
	end
}

function _loadSymbols()
	_symbolDefinitions = {}
	_symbolsByType = {}

	local symbolDefinition

	for key, name in pairs(config.symbolTypes) do
		symbolDefinition = plugins.style:lazyRequire('selectors.symbols.' .. name)

		if (type(symbolDefinition.name) ~= 'string') then
			_printSymbolError('Does not have a name', name)

		elseif (type(symbolDefinition.prefix) ~= 'string') then
			_printSymbolError('Does not specify a prefix', name)

		elseif (type(symbolDefinition.reader) ~= 'function') then
			_printSymbolError('Does not have a reader function', name)

		end

		-- Add to the symbols list
		table.insert(_symbolDefinitions, symbolDefinition)

		-- Add to the symbols by type map
		_symbolsByType[name] = symbolDefinition
	end
end

function _printSymbolError(message, name)
	message = 'Error parsing symbol definition %q: ' .. message

	error(message:format(name))
end

_loadSymbols()

return SymbolLoader
