
-- List of combination modes (things like '>', '~', ' ' etc) that can be used to
-- join segments of an expression together. The corresponding combination definition
-- file for each of these is loaded in from the combinators folder.
local combinationModes =
{
	CHILD = 'child',
	DESCENDANT = 'descendant'
}

-- List of symbol types modes (things like nodeType, tag, pseudo etc) that can be
-- used to set criteria for selecting nodes. The corresponding symbol definition
-- file for each of these is loaded in from the symbols folder.
local symbolTypes =
{
	NODE = 'node',
	TAG = 'tag',
	PSEUDO_TAG = 'pseudoTag'
}

-- Order in which symbols should trump each another when calculating specificity
-- (see the description of SpecificityCalculator.calculate() for more info).
--
-- This list is in descending order, i.e. symbol types at the start of the list
-- are considered to contribute more to the specificity of a selector than those
-- at the end of the list.
--
-- Note that as it is possible for more than one symbol type to have the same
-- specificity rating (as is the case with tags and pseudo tags), each level in
-- the specificity list is a table comprising symbols which share the same rating.
local symbolSpecificity =
{
	{ symbolTypes.TAG, symbolTypes.PSEUDO_TAG },     -- Most specific symbols
	{ symbolTypes.NODE }                             -- Least specific symbols
}

-- Exports
return
{
	combinationModes = combinationModes,
	symbolTypes = symbolTypes,
	symbolSpecificity = symbolSpecificity
}