
local SelectorExpressionSegment = plugins.style:lazyRequire('selectors.SelectorExpressionSegment')
local SpecificityCalculator = plugins.style:lazyRequire('selectors.specificity.SpecificityCalculator')

local SelectorExpression = class(function(self)

	-- Raw string that was used to specify this expression.
	self.rawString = nil

	-- List of segments making up the expression.
	self.segments = {}

	-- Specificity of the expression as calculated by SpecificityCalculator.
	self.specificity = nil

end)

function SelectorExpression:addSegment(combinationMode)
	local segment = SelectorExpressionSegment.new(combinationMode)
	table.insert(self.segments, segment)

	return segment
end

function SelectorExpression:calculateSpecificity()
	self.specificity = SpecificityCalculator.calculate(self)
end

return SelectorExpression

