-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local djb2Hash = crypto.djb2Hash

local PropertyStyle = plugins.style:lazyRequire('rules.styles.definitions.PropertyStyle')

local ViewsStyle = class(
	-- Parent class
	PropertyStyle,

	-- Constructor
	function(self, handle, value, containingStyles, context)
		PropertyStyle._ctor(self, handle, value, containingStyles, context)
	end
)

function ViewsStyle:_setPropertyValue(node, value)
	local viewElement = context:getNodesRegistry():getViewElement(node:getId())

	if viewElement then
		if viewElement.acceptsProperty then
			if viewElement:acceptsProperty(self._name) then
				viewElement:setProperty(self._name, value)
			else
				error(
						"View '" .. viewElement.typeName .. "' does not accept " ..
						"property '" .. self._name .. "'.")
			end
		else
			error("'viewProperties' can only be set on the root node of a view.")
		end
	end
end

function ViewsStyle:removeFromNode(node)
	-- Do nothing.
end

return ViewsStyle