-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local BlendMode = plugins.style:lazyRequire('rules.enums.BlendMode')
local ParseMode = plugins.style:lazyRequire('rules.enums.ParseMode')
local RenderMode = plugins.style:lazyRequire('rules.enums.RenderMode')
local Pivot = plugins.style:lazyRequire('rules.enums.PivotMode')
local Alignment = plugins.style:lazyRequire('rules.enums.Alignment')
local VerticalAlignment = plugins.style:lazyRequire('rules.enums.VerticalAlignment')
local Vec2 = plugins.style:lazyRequire('expressions.definitions.types.Vec2Type')
local Vec3 = plugins.style:lazyRequire('expressions.definitions.types.Vec3Type')
local Vec4 = plugins.style:lazyRequire('expressions.definitions.types.Vec4Type')
local Rect = plugins.style:lazyRequire('expressions.definitions.types.RectType')
local PivotMode = plugins.style:lazyRequire('expressions.definitions.types.PivotModeType')
local FontWeight = plugins.style:lazyRequire('rules.enums.FontWeight')
local MipmappingMode = plugins.style:lazyRequire('rules.enums.MipmappingMode')
local SourceChangeMode = plugins.style:lazyRequire('rules.enums.SourceChangeMode')
local ImageLoadMode = plugins.style:lazyRequire('rules.enums.ImageLoadMode')

--
-- Lists default values for each node property, for use in resetting the default
-- values of properties when styles which manipulated those properties no longer
-- match a given node.
--
return
{
	--
	-- Properties belonging to SceneNode
	--
	id = -1,
	
	position = Vec3(0.0, 0.0, 0.0),
	x = 0.0,
	y = 0.0,
	z = 0.0,
	left = 0.0,
	right = 0.0,
	top = 0.0,
	bottom = 0.0,
	front = 0.0,
	back = 0.0,

	size = Vec3(0.0, 0.0, 0.0),
	width = 0.0,
	height = 0.0,
	depth = 0.0,

	compositeSize = Vec3(0.0, 0.0, 0.0),
	compositeWidth = 0.0,
	compositeHeight = 0.0,
	compositeDepth = 0.0,

	scale = Vec3(1.0, 1.0, 1.0),
	scaleX = 1.0,
	scaleY = 1.0,
	scaleZ = 1.0,

	rotation = Vec4(0.0, 0.0, 0.0, 0.0),
	rotationAxisX = 0.0,
	rotationAxisY = 0.0,
	rotationAxisZ = 0.0,
	rotationAxisAngle = 0.0,

	blendMode = BlendMode.OPAQUE,
	parseMode = ParseMode.NORMAL,
	renderMode = RenderMode.AUTO,
	pivotMode = PivotMode(Pivot.CENTER, Pivot.CENTER, Pivot.CENTER),
	pivotPosition = Vec3(0, 0, 0),
	visible = true,
	alpha = 1,
	drawIndex = 0,

	--
	-- Properties belonging to ImageNode
	--
	fileType = '',
	source = '',
	sliceRect = Rect(0, 0, 0, 0),
	mipmappingMode = MipmappingMode.NONE,
	sourceChangeMode = SourceChangeMode.ERASE_PREVIOUS_IMMEDIATELY,
	imageLoadMode = ImageLoadMode.USE_IMAGE_SEQUENCER,

	--
	-- Properties belonging to TextNode
	--
	text = '',
	alignment = Alignment.CENTER,
	verticalAlignment = VerticalAlignment.MIDDLE,
	fontColor = Vec3(1, 1, 1),
	wrapBounds = Vec2(0, 0),
	fontSize = 48,
	fontWeight = FontWeight.NORMAL,

	--
	-- Properties belonging to CameraNode
	--
	-- TODO: Work out how these default values should be initialised, as rather
	-- than being constants they're actually calculated by CameraNode.cpp at
	-- startup time.
	eye = Vec3(0.0, 0.0, 0.0),
	center = Vec3(0.0, 0.0, 0.0),
	direction = Vec3(0.0, 0.0, 0.0)
}
