
-- List of phases during which styles can be applied. In some cases the phase
-- can have a bearing on the evaluation of different expression types.
local StyleApplicationPhases =
{
	-- A style is being applied to a node for the first time, i.e. on the
	-- previous tick the property had no style whatsoever.
	INITIAL_APPLICATION = 'StyleApplicationPhases::INITIAL_APPLICATION',

	-- A more specific style is being applied over the top of another style,
	-- i.e. a style previously applied to the property has been superseded
	-- by this style.
	SPECIFICITY_UPDATE = 'StyleApplicationPhases::SPECIFICITY_UPDATE',

	-- A style is are being re-applied after a binding has updated.
	BINDING_UPDATE = 'StyleApplicationPhases::BINDING_UPDATE',
}

return StyleApplicationPhases