-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractNodeKeyword = plugins.style:lazyRequire('rules.keywords.AbstractNodeKeyword')

local SOURCE_NODE_TYPE = 'previous'

--
-- Node keyword used for reading from the current node's previous sibling.
--
local PreviousNodeKeyword = class(

	-- Parent class
	AbstractNodeKeyword,

	-- Constructor
	function(self, isLive)
		AbstractNodeKeyword._ctor(self, SOURCE_NODE_TYPE, isLive)
	end
)

PreviousNodeKeyword.SOURCE_NODE_TYPE = SOURCE_NODE_TYPE

-- Traversal method for this NodeKeyword. For 'previous' nodes we need to check
-- that the current node has a parent, and then if so attempt to retrieve the
-- previous sibling in the parent's children array by just subtracting one from
-- the index of the current node.
function PreviousNodeKeyword:_doTraversal(currentNode)
	if currentNode:hasParent() then
		local parent = currentNode:getParent()
		local index = currentNode:getIndexInParent()

		if index > 0 then
			return parent:getChildAtIndex(index - 1)
		end
	end
end

-- Used for converting back from a table representation when transferring from
-- the definition state to the application state.
function PreviousNodeKeyword.fromTable(table)
	return PreviousNodeKeyword.new(table.isLive)
end

return PreviousNodeKeyword
