-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractNodeKeyword = plugins.style:lazyRequire('rules.keywords.AbstractNodeKeyword')

local SOURCE_NODE_TYPE = 'current'

--
-- Node keyword used for reading from the current node.
--
local CurrentNodeKeyword = class(

	-- Parent class
	AbstractNodeKeyword,

	-- Constructor
	function(self, isLive)
		AbstractNodeKeyword._ctor(self, SOURCE_NODE_TYPE, isLive)
	end
)

CurrentNodeKeyword.SOURCE_NODE_TYPE = SOURCE_NODE_TYPE

-- Traversal method for this NodeKeyword. For 'current' nodes this is easy as
-- we're already at the current node :) so this method just returns it directly.
function CurrentNodeKeyword:_doTraversal(currentNode)
	return currentNode
end

-- Used for converting back from a table representation when transferring from
-- the definition state to the application state.
function CurrentNodeKeyword.fromTable(table)
	return CurrentNodeKeyword.new(table.isLive)
end

return CurrentNodeKeyword
