
local _idCounter = 0

local Rule = class(function(self, selector, stylesheetPath, styles)

	_idCounter = _idCounter + 1
	self.ruleId = _idCounter

	self.selector = selector
	self.stylesheetPath = stylesheetPath
	self.styles = styles
	self.viewScope = nil
	
	self:_inferViewScopeFromStylesheetPath()

end)

-- In order to enable easy association of styles with the view that they are
-- intended to style, the view scope for each rule can be inferred from the name
-- of the file within which it was defined.
--
-- Essentially, if the name of the file ends in 'View.lua' then it will be assumed
-- to be intended to be associated with a view of the same name, and this will then
-- be used as the view scope.
function Rule:_inferViewScopeFromStylesheetPath()
	local path = self.stylesheetPath

	if path and path:sub(-8) == 'View.lua' then
		self.viewScope = path:match('([%a%d]+)%.lua$')
	end
end

return Rule



