-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local CounterCategory = class(function(self, name)
	self._name = name
	self._counters = {}
end)

function CounterCategory:getName()
	return self._name
end

function CounterCategory:addCounter(counter)
	table.insert(self._counters, counter)
end

function CounterCategory:getCounters()
	return self._counters
end

function CounterCategory:reset()
	for j, counter in ipairs(self._counters) do
		counter:reset()
	end
end

function CounterCategory:anyCountersAreGreaterThanZero()
	for j, counter in ipairs(self._counters) do
		if counter:getCount() > 0 then
			return true
		end
	end
	
	return false
end

return CounterCategory
