-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local MutationType = plugins.style:lazyRequire('mutations.MutationType')

local MutationConfig = 
{
	-- Configures which MutationTypes the rule application process needs to
	-- know about so that it can apply any rules which are dependent on the
	-- mutations.
	--
	-- This must must be updated if new mutation types are added to the scene
	-- plugin which the rule application process needs to know about - any types
	-- which aren't listed here will be ignored.
	REQUIRED_MUTATION_TYPES = 
	{
		MutationType.CHILD_ADDED,
		MutationType.TAG_ADDED,
		MutationType.TAG_REMOVED,
		MutationType.INDEX_CHANGED,
		MutationType.TEXT_REFLOWED,
		MutationType.IMAGE_LOADED,
		MutationType.INFERRED_DIMENSIONS_CHANGED,
		MutationType.PARTITION_CHANGED
	},
	
	-- Configures which MutationTypes need to be propagated down the graph. The
	-- list of mutation types listed here includes all of those which affect a
	-- node's matchability or can be referenced from a selector.
	--
	-- For example, as tags can be referenced in selectors, the addition or
	-- removal of a tag from a node can affect the matchability of not just that
	-- node but also any descendant nodes that may be selected via a descendant
	-- selector. To enable the matching algorithm to check all affected nodes 
	-- for new matches, the addition or removal of a tag from a node is propagated
	-- all the way down the graph to all descendants of the mutated node.
	PROPAGATED_MUTATION_TYPES = 
	{
		MutationType.CHILD_ADDED,
		MutationType.TAG_ADDED,
		MutationType.TAG_REMOVED,
		MutationType.IMAGE_LOADED
	}
}

return MutationConfig