-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local TableUtils = plugins.style:lazyRequire('utils.TableUtils')
local PropertyTypes = plugins.style:lazyRequire('rules.styles.definitions.PropertyTypes')
local TypeRuntimeExpression = plugins.style:lazyRequire('expressions.definitions.TypeRuntimeExpression')

--
-- Function representing the 'Vec4' type used for sizes/dimensions etc.
--
-- Generates a TypeRuntimeExpression for which will create a LuaVec4 CDATA when
-- evaluated at runtime.
--
return function(x, y, z, w)
	local values = { x, y, z, w }

	assert(#values == 4, 'Vec4 takes exactly four arguments')
	assert(TableUtils.allOfType(values, 'number'), 'Vec4 arguments must be numbers')

	return TypeRuntimeExpression.new(PropertyTypes.VEC4, values)
end
