-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local TableUtils = plugins.style:lazyRequire('utils.TableUtils')
local Vec3 = plugins.style:lazyRequire('expressions.definitions.types.Vec3Type')

local function validRange(value)
	return (value >= 0) and (value <= 255)
end

--
-- Converts a Vec3 representing RGB colors (values between 0 and 255) to a
-- normalized Vec3 (values between 0 and 1)
--
return function(red, green, blue)
	local values = {red, green, blue}

	assert(#values == 3, 'RgbColor takes exactly three arguments')
	assert(TableUtils.allOfType(values, 'number'), 'RgbColor arguments must be numbers')
	assert(validRange(red), '"red" argument of RgbColor must be between 0 and 255')
	assert(validRange(green), '"green" argument of RgbColor must be between 0 and 255')
	assert(validRange(blue), '"blue" argument of RgbColor must be between 0 and 255')

	return Vec3(red/255.0, green/255.0, blue/255.0)
end
